<?php

namespace Amwdeveloper\controller;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;

class authuser extends layer
{
    public $session;
    public $message;

    public function sessionuser()
    {
        $this->session = new session();
        return $this->session;
    }

    public function messageuser()
    {
        $this->message = new message();
        return $this->message;
    }

    public function previlegymanager(string $vip): bool
    {
        $account = $this->table("MEMB_INFO")->columns("" . config['column_vip'] . " as vip")->where("memb___id = :mi", "mi={$this->sessionuser()->useraccount}")->get();
        if ($account->vip < $vip) return true;
        return false;
    }

    public function loggedaccountgame()
    {
        $account = $this->table("MEMB_STAT")->columns("ConnectStat")->where("memb___id = :mi", "mi={$this->sessionuser()->useraccount}")->get();
        if ($account->ConnectStat == 1) return true;
        return false;
    }

    public function geratetokencsrf()
    {
        $this->sessionuser()->set('token_csrf', md5(uniqid()));
    }

    public function postloginaccount($request)
    {

        $account_user = filter_var($request['account_user'], FILTER_SANITIZE_SPECIAL_CHARS);
        $account_passwd = filter_var($request['account_passwd'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (requests_form("login_account", 5, 15)) {
            $this->messageuser()->class("error")->text("IP: {$_SERVER['REMOTE_ADDR']} bloqueado por <em><strong>15 minutos</strong></em>")->flash(true);
            return null;
        }

        if (empty($account_user) or empty($account_passwd)) {
            $this->messageuser()->class("error")->text("Preecha os campos <em><strong>Usúario & Senha</strong></em>")->flash();
            return null;
        }

        $verifyaccount = $this->table("MEMB_INFO")->columns("memb___id, memb__pwd")->where("memb___id = :mi AND memb__pwd = :mp", "mi={$account_user}&mp={$account_passwd}")->get();

        if (empty($verifyaccount)) {
            $this->messageuser()->class("error")->text("<em><strong>Usúario/Senha</strong> incorreto</em>")->flash();
            return null;
        }

        /*$verifyaccountEmailActive = $this->table("MEMB_INFO")->columns("mail_chek")->where("mail_chek = :mc AND memb___id = :mi ", "mc=1&mi={$account_user}")->get();
        if (empty($verifyaccountEmailActive)) {
            $this->messageuser()->class("error")->text("<em><strong>Conta não verificada</strong>, acesse seu email e ative sua conta!</em>")->flash();
            return null;
        }*/

        $this->sessionuser()->set("useraccount", $account_user);
        $this->messageuser()->class("success")->text("Logado com sucesso <br> <em><strong>Aguarde...</strong></em>")->flash(true, false, __redirect(""));
        $this->geratetokencsrf();
        $this->sessionuser()->set("login_account", ['block' => null, 'request' => 1]);
    }

    public function postmanageemail($request)
    {
        $oldemail = filter_var($request['oldemail'], FILTER_VALIDATE_EMAIL);
        $newemail = filter_var($request['newemail'], FILTER_VALIDATE_EMAIL);
        $token_form = filter_var($request['token_form'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($this->sessionuser()->token_csrf != $token_form) {
            $this->messageuser()->class("error")->text("<em><strong>Token</strong></em> incorreto, atualize a página!")->flash();
            return null;
        }

        if (requests_form("fail_email", 5, 10)) {
            $this->messageuser()->class("error")->text("Ip: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        if (empty($oldemail)) {
            $this->messageuser()->class("error")->text("Campo <em><strong>e-mail</strong></em> antigo vázio/inválido")->flash();
            return null;
        }

        if (empty($newemail)) {
            $this->messageuser()->class("error")->text("Campo novo <em><strong>e-mail</strong></em> vázio/inválido")->flash();
            return null;
        }

        if (strlen($newemail) < 10) {
            $this->messageuser()->class("error")->text("Seu <em><strong>e-mail</strong></em> deve conter <em><strong>entre 4 à 60 caracteres</strong></em>")->flash();
            return null;
        }

        $verifyemail = $this->table("MEMB_INFO")->columns("mail_addr")->where("memb___id = :mi AND mail_addr = :mail", "mi={$this->sessionuser()->useraccount}&mail={$oldemail}")->get();

        if (empty($verifyemail)) {
            $this->messageuser()->class("error")->text("<em><strong>E-mail antigo</strong></em> é inválido")->flash();
            return null;
        }

        if ($verifyemail->mail_addr == $newemail) {
            $this->messageuser()->class("error")->text("Você já está usando este e-mail <br> <em><strong>Informe um e-mail diferente</strong></em>")->flash();
            return null;
        }

        $verifyexistemail = $this->table("MEMB_INFO")->columns("mail_addr")->where("memb___id != :mi AND mail_addr = :mail", "mi={$this->sessionuser()->useraccount}&mail={$newemail}")->get();

        if (!empty($verifyexistemail)) {
            $this->messageuser()->class("error")->text("<em><strong>E-mail novo</strong></em> já está em uso")->flash();
            return null;
        }

        if (requests_form("manage_email", 2, 10)) {
            $this->messageuser()->class("error")->text("Você atualizou seu e-mail recentemente, aguarde <em><strong>10 minutos</strong></em>")->flash();
            return null;
        }

        $this->table("MEMB_INFO")->where("memb___id = :mi", "mi={$this->sessionuser()->useraccount}")->updated(['mail_addr' => $newemail]);
        $this->messageuser()->class("success")->text("<em><strong>E-mail</strong></em> atualizado com sucesso")->flash(true, true);
        $this->geratetokencsrf();
    }

    public function postmanagepasswd($request)
    {
        $oldpasswd = filter_var($request['oldpasswd'], FILTER_SANITIZE_SPECIAL_CHARS);
        $newpasswd = filter_var($request['newpasswd'], FILTER_SANITIZE_SPECIAL_CHARS);
        $token_form = filter_var($request['token_form'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($this->sessionuser()->token_csrf != $token_form) {
            $this->messageuser()->class("error")->text("<em><strong>Token</strong></em> incorreto, atualize a página!")->flash();
            return null;
        }

        if (requests_form("fail_passwd", 5, 10)) {
            $this->messageuser()->class("error")->text("Ip: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        if (empty($oldpasswd)) {
            $this->messageuser()->class("error")->text("Preecha o campo <em><strong>senha antiga</strong></em>")->flash();
            return null;
        }

        $verifypasswd = $this->table("MEMB_INFO")->where("memb___id = :mi AND memb__pwd = :mp", "mi={$this->sessionuser()->useraccount}&mp={$oldpasswd}")->get();

        if (empty($verifypasswd)) {
            $this->messageuser()->class("error")->text("<em><strong>Senha antiga</strong></em> inválida")->flash();
            return null;
        }

        if (strlen($newpasswd) < 4 or strlen($newpasswd) > 10) {
            $this->messageuser()->class("error")->text("Sua <em><strong>senha</strong></em> precisa ser <em><strong>entre 4 à 10 caracteres</strong></em>")->flash();
            return null;
        }

        if (!preg_match("/^[a-zA-Z-0-9]+$/i", $newpasswd)) {
            $this->messageuser()->class("error")->text("Não use <em><strong>símbolos</strong></em> em sua senha")->flash();
            return null;
        }

        if (requests_form("manage_passwd", 2, 10)) {
            $this->messageuser()->class("error")->text("Você atualizou sua senha recentemente, aguarde <em><strong>10 minutos</strong></em>")->flash();
            return null;
        }

        $this->table("MEMB_INFO")->where("memb___id = :mi", "mi={$this->sessionuser()->useraccount}")->updated(['memb__pwd' => $newpasswd]);
        $this->messageuser()->class("success")->text("<em><strong>Senha</strong></em> atualizada com sucesso")->flash(true, true);
        $this->geratetokencsrf();
    }

    public function postmanagepersonalid($request)
    {
        $newpid = $request['pid'];
        $token_form = filter_var($request['token_form'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($this->sessionuser()->token_csrf != $token_form) {
            $this->messageuser()->class("error")->text("<em><strong>Token</strong></em> incorreto, atualize a página!")->flash();
            return null;
        }

        if (requests_form("fail_pid", 5, 10)) {
            $this->messageuser()->class("error")->text("Ip: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        if (!is_numeric($newpid)) {
            $this->messageuser()->class("error")->text("Preencha o campo <em><strong>PersonalID</strong></em> apenas com números")->flash();
            return null;
        }

        if (strlen($newpid) != 7) {
            $this->messageuser()->class("error")->text("Seu <em><strong>Personal ID</strong></em> deve conter <em><strong>7 números</strong></em>")->flash();
            return null;
        }

        if (requests_form("manage_personalid", 2, 10)) {
            $this->messageuser()->class("error")->text("Você atualizou seu personalID recentemente, aguarde <em><strong>10 minutos</strong></em>")->flash();
            return null;
        }

        $this->table("MEMB_INFO")->where("memb___id = :mi", "mi={$this->sessionuser()->useraccount}")->updated(['sno__numb' => '111111' . $newpid]);
        $this->messageuser()->class("success")->text("<em><strong>PersonalID</strong></em> alterado com sucesso")->flash(true, true);
        $this->geratetokencsrf();
    }

    public function postexchangecoins($request)
    {
        $coin = $request['exchange'];
        $token_form = filter_var($request['token_form'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($this->sessionuser()->token_csrf != $token_form) {
            $this->messageuser()->class("error")->text("<em><strong>Token</strong></em> incorreto, atualize a página!")->flash();
            return null;
        }

        if (requests_form("fail_coins", 5, 10)) {
            $this->messageuser()->class("error")->text("Ip: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        if (!is_numeric($coin)) {
            $this->messageuser()->class("error")->text("<em><strong>Selecione uma forma de troca</strong></em>")->flash();
            return null;
        }

        $discount = coins[currency['discount']];

        $currency = currency['select_exchange'][$coin];


        $verifycoindiscount = $this->table("{$discount['table']}")->columns("{$discount['column_coin']}  as discount")->where("{$discount['column_account']} = :mi", "mi={$this->sessionuser()->useraccount}")->get();

        if ($verifycoindiscount->discount < $currency['coin_1']) {
            $this->messageuser()->class("error")->text("Você não possuí <em><strong>{$currency['coin_1']} {$discount['name_coin']}</strong></em>")->flash();
            return null;
        }

        $recepient = coins[currency['recepient']];

        $verifycoinrecepient =  $this->table("{$recepient['table']}")->columns("{$recepient['column_coin']}  as recepient")->where("{$recepient['column_account']} = :mi", "mi={$this->sessionuser()->useraccount}")->get();
        $updaterecepient = array($recepient['column_coin'] => ($verifycoinrecepient->recepient + $currency['coin_2']));

        $updatediscount = array($discount['column_coin'] => ($verifycoindiscount->discount - $currency['coin_1']));


        $this->table($recepient['table'])->where("{$recepient['column_account']} = :mi", "mi={$this->sessionuser()->useraccount}")->updated($updaterecepient);
        $this->table($discount['table'])->where("{$discount['column_account']} = :mi", "mi={$this->sessionuser()->useraccount}")->updated($updatediscount);

        $this->messageuser()->class("success")->text("Você trocou <em><strong>{$currency['coin_1']} {$discount['name_coin']} por {$currency['coin_2']} {$recepient['name_coin']}</strong></em> com sucesso")->flash(true, true);
        $this->geratetokencsrf();
    }

    /** Character */

    public function postmanagenickcharacter($request)
    {
        $oldnick = filter_var($request['char'], FILTER_SANITIZE_SPECIAL_CHARS);
        $nick = filter_var($request['newnick'], FILTER_SANITIZE_SPECIAL_CHARS);
        $token_form = filter_var($request['token_form'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($this->sessionuser()->token_csrf != $token_form) {
            $this->messageuser()->class("error")->text("<em><strong>Token</strong></em> incorreto, atualize a página!")->flash();
            return null;
        }

        if (requests_form("fail_nick", 5, 10)) {
            $this->messageuser()->class("error")->text("Ip: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        $verifychar = $this->table("Character")->columns("AccountID")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$oldnick}")->get();
        if (empty($verifychar)) {
            $this->messageuser()->class("error")->text("<em><strong>Personagem não pertence a sua conta</strong></em>, atualize a página e tente novamente")->flash();
            return null;
        }

        if ($this->loggedaccountgame()) {
            $this->messageuser()->class("error")->text("Deslogue sua <em><strong>conta no jogo</strong></em>, para continuar")->flash();
            return null;
        }

        if (empty($nick)) {
            $this->messageuser()->class("error")->text("Campo <em><strong>Nick</strong></em> vázio")->flash();
            return null;
        }

        if (!preg_match("/^[a-zA-Z0-9_\][-]+$/i", $nick)) {
            $this->messageuser()->class("error")->text("Não use simbolos em seu <em><strong>Nick</strong></em>")->flash();
            return null;
        }

        if (strlen($nick) < 4 or strlen($nick) > 10) {
            $this->messageuser()->class("error")->text("Seu <em><strong>Nick</strong></em> deve conter <em><strong>entre 4 à 10 caracteres</strong></em>")->flash();
            return null;
        }

        if ($this->previlegymanager(previlegy_character['manage_nick']['plan_vip'])) {
            $this->messageuser()->class("error")->text("Sua conta não tem <em><strong>Previlégio</strong></em>, veja mais em informações")->flash(true);
            return null;
        }

        $gameidc = $this->table("AccountCharacter")->where("Id=:acc", "acc={$this->sessionuser()->useraccount}")->all();
        $gameselect = '';

        foreach ($gameidc as $game) {
            $game->GameID1 == $oldnick ? $gameselect = "GameID1" : null;
            $game->GameID2 == $oldnick ? $gameselect = "GameID2" : null;
            $game->GameID3 == $oldnick ? $gameselect = "GameID3" : null;
            $game->GameID4 == $oldnick ? $gameselect = "GameID4" : null;
            $game->GameID5 == $oldnick ? $gameselect = "GameID5" : null;
        }

        if (empty($gameselect)) {
            $this->messageuser()->class("error")->text("<em><strong>Erro interno</strong></em>, atualize a página e tente novamente")->flash();
            return null;
        }

        if ($oldnick == $nick) {
            $this->messageuser()->class("error")->text("Você já está a usar este <em><strong>Nick</strong></em>")->flash();
            return null;
        }

        $verifycharexist = $this->table("Character")->columns("Name")->where("Name = :name", "name={$nick}")->get();

        if (!empty($verifycharexist)) {
            $this->messageuser()->class("error")->text("<em><strong>Nick</strong></em>, já está em uso")->flash();
            return null;
        }

        $verifyAccountGuild = $this->table("GuildMember")->columns("Name")->where("Name = :name", "name={$nick}")->get();

        if (!empty($verifyAccountGuild)) {
            $this->messageuser()->class("error")->text("Atenção: <em><strong>Saia da guild</strong></em>, para alterar o nick")->flash();
            return null;
        }

        if (requests_form("manage_nick", 2, 10)) {
            $this->messageuser()->class("error")->text("Você atualizou seu nick recentemente, aguarde <em><strong>10 minutos</strong></em>")->flash();
            return null;
        }



        $this->table("AccountCharacter")->where("Id = :acc", "acc={$this->sessionuser()->useraccount}")->updated([$gameselect => $nick]);
        $this->table("Character")->where("Name = :name AND AccountID = :acc", "name={$oldnick}&acc={$this->sessionuser()->useraccount}")->updated(['Name' => $nick]);
        $this->messageuser()->class("success")->text("<em><strong>Nick</strong></em> alterado com sucesso")->flash(true, true);
        $this->geratetokencsrf();
    }

    public function postmanageclasscharacter($request)
    {
        $char = filter_var($request['char'], FILTER_SANITIZE_SPECIAL_CHARS);
        $class = $request['class'];
        $token_form = filter_var($request['token_form'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($this->sessionuser()->token_csrf != $token_form) {
            $this->messageuser()->class("error")->text("<em><strong>Token</strong></em> incorreto, atualize a página!")->flash();
            return null;
        }

        if (requests_form("fail_class", 5, 10)) {
            $this->messageuser()->class("error")->text("IP: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        $verifychar = $this->table("Character")->columns("AccountID")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$char}")->get();
        if (empty($verifychar)) {
            $this->messageuser()->class("error")->text("<em><strong>Personagem não pertence a sua conta</strong></em>, atualize a página e tente novamente")->flash();
            return null;
        }

        if ($this->loggedaccountgame()) {
            $this->messageuser()->class("error")->text("Deslogue sua <em><strong>conta no jogo</strong></em>, para continuar")->flash();
            return null;
        }

        if (!is_numeric($class)) {
            $this->messageuser()->class("error")->text("Campo <em><strong>classe</strong></em> vázio")->flash();
            return null;
        }

        if (empty(characters['classes'][$class])) {
            $this->messageuser()->class("error")->text("<em><strong>classe</strong></em> informada é inválida")->flash();
            return null;
        }

        if ($this->previlegymanager(previlegy_character['manage_class']['plan_vip'])) {
            $this->messageuser()->class("error")->text("Sua conta não tem <em><strong>Previlégio</strong></em>, veja mais em informações")->flash(true);
            return null;
        }

        if (requests_form("manage_class", 2, 10)) {
            $this->messageuser()->class("error")->text("Você atualizou sua classe recentemente, aguarde <em><strong>10 minutos</strong></em>")->flash();
            return null;
        }

        $invetory = $this->table("Character")->columns("Inventory as items")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$char}")->get();

        if (preg_match('/[abcdeghijklmnop01234567]/i', bin2hex($invetory->items))) {
            $this->messageuser()->class("error")->text("Deixe seu <em><strong>Inventário vázio</strong></em>, para continuar")->flash(true);
            return null;
        }

        $this->table("Character")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$char}")->updated(['Class' => $class, 'MagicList' => NULL]);
        $this->messageuser()->class("success")->text("<em><strong>Classe</strong></em> alterada com sucesso")->flash(true, true);
        $this->geratetokencsrf();
    }

    public function postmanagemovecharacter($request)
    {
        $char = filter_var($request['char'], FILTER_SANITIZE_SPECIAL_CHARS);
        $move = $request['move'];
        $token_form = filter_var($request['token_form'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($this->sessionuser()->token_csrf != $token_form) {
            $this->messageuser()->class("error")->text("<em><strong>Token</strong></em> incorreto, atualize a página!")->flash();
            return null;
        }

        if (requests_form("fail_move", 5, 10)) {
            $this->messageuser()->class("error")->text("IP: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        $verifychar = $this->table("Character")->columns("AccountID")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$char}")->get();
        if (empty($verifychar)) {
            $this->messageuser()->class("error")->text("<em><strong>Personagem não pertence a sua conta</strong></em>, atualize a página e tente novamente")->flash();
            return null;
        }

        if ($this->loggedaccountgame()) {
            $this->messageuser()->class("error")->text("Deslogue sua <em><strong>conta no jogo</strong></em>, para continuar")->flash();
            return null;
        }
        if (!is_numeric($move)) {
            $this->messageuser()->class("error")->text("Campo <em><strong>move</strong></em> vázio")->flash();
            return null;
        }

        if (empty(maps[$move])) {
            $this->messageuser()->class("error")->text("<em><strong>Move</strong></em> informado é inválido")->flash();
            return null;
        }

        if ($this->previlegymanager(previlegy_character['manage_move']['plan_vip'])) {
            $this->messageuser()->class("error")->text("Sua conta não tem <em><strong>Previlégio</strong></em>, veja mais em informações")->flash(true);
            return null;
        }

        $namemove = maps[$move]['name'];
        $positions = explode("x", maps[$move]['born']);
        $posx = $positions[0];
        $posy = $positions[1];

        $moveinfo = [
            'MapNumber' => $move,
            'MapPosX' => $posx,
            'MapPosY' => $posy
        ];

        if (requests_form("manage_move", 2, 10)) {
            $this->messageuser()->class("error")->text("Você atualizou seu move recentemente, aguarde <em><strong>10 minutos</strong></em>")->flash();
            return null;
        }

        $this->table("Character")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$char}")->updated($moveinfo);
        $this->messageuser()->class("success")->text("Movido para <em><strong>{$namemove}</strong></em> com sucesso")->flash(true, true);
        $this->geratetokencsrf();
    }

    public function postmanageavatarcharacter($request)
    {

        $char = filter_var($request['char'], FILTER_SANITIZE_SPECIAL_CHARS);
        $token_form = filter_var($request['token_form'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($this->sessionuser()->token_csrf != $token_form) {
            $this->messageuser()->class("error")->text("<em><strong>Token</strong></em> incorreto, atualize a página!")->flash();
            return null;
        }


        if (requests_form("fail_avatar", 5, 10)) {
            $this->messageuser()->class("error")->text("IP: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        $verifychar = $this->table("Character")->columns("AccountID")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$char}")->get();
        if (empty($verifychar)) {
            $this->messageuser()->class("error")->text("<em><strong>Personagem não pertence a sua conta</strong></em>, atualize a página e tente novamente")->flash();
            return null;
        }

        if ($this->loggedaccountgame()) {
            $this->messageuser()->class("error")->text("Deslogue sua <em><strong>conta no jogo</strong></em>, para continuar")->flash();
            return null;
        }

        if ($this->previlegymanager(previlegy_character['manage_avatar']['plan_vip'])) {
            $this->messageuser()->class("error")->text("Sua conta não tem <em><strong>Previlégio</strong></em>, veja mais em informações")->flash(true);
            return null;
        }

        if ($_FILES['image']['name']) {

            if ($_FILES['image']['size'] > 150000) {
                $this->messageuser()->class("error")->text("Imagem não pode ser maior que <em><strong>150Kbs</strong></em>")->flash(true);
                return null;
            }

            $extension = array('image/png', 'image/jpg', 'image/gif', 'image/jpeg');

            if (!in_array($_FILES['image']['type'], $extension)) {
                $this->messageuser()->class("error")->text("<em><strong>Formato de imagem</strong></em> inválido")->flash(true);
                return null;
            }

            $resource = __DIR__ . '/../../resource/avatar/';
            $newname = md5(uniqid()) . mb_strrchr($_FILES['image']['name'], ".");
            $temp = $_FILES['image']['tmp_name'];

            if (requests_form("manage_avatar", 2, 10)) {
                $this->messageuser()->class("error")->text("Você atualizou seu avatar recentemente, aguarde <em><strong>10 minutos</strong></em>")->flash();
                return null;
            }

            if (move_uploaded_file($temp, $resource . $newname)) {
                $image = $this->table("Character")->where("Name =:name", "name={$char}")->get();

                if (!empty($image->Imagem)) {
                    unlink($resource . $image->Imagem);
                }

                $this->table("Character")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$char}")->updated(['Imagem' => $newname]);
                $this->messageuser()->class("success")->text("<em><strong>Avatar</strong></em> alterado com sucesso")->flash(true);
                $this->geratetokencsrf();
                return null;
            }
        } else {
            $this->messageuser()->class("error")->text("Selecione uma <em><strong>Imagem (png.jpg,gif)</strong></em>")->flash(true);
            return null;
        }
    }

    public function postmanageblockprofilecharacter($request)
    {

        $char = filter_var($request['char'], FILTER_SANITIZE_SPECIAL_CHARS);
        $token_form = filter_var($request['token_form'], FILTER_SANITIZE_SPECIAL_CHARS);
        $block = isset($request['blocked']) ? $request['blocked'] : null;

        if ($block === null) {
            $this->messageuser()->class("error")->text("Escolha uma opção.")->flash();
            return null;
        }

        if ($this->sessionuser()->token_csrf != $token_form) {
            $this->messageuser()->class("error")->text("<em><strong>Token</strong></em> incorreto, atualize a página!")->flash();
            return null;
        }

        if (requests_form("fail_bloc_profile", 5, 10)) {
            $this->messageuser()->class("error")->text("IP: {$_SERVER['REMOTE_ADDR']}, bloqueado por <em><strong>10 minutos</strong></em>")->flash(true);
            return null;
        }

        $verifychar = $this->table("Character")->columns("AccountID")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$char}")->get();
        if (empty($verifychar)) {
            $this->messageuser()->class("error")->text("<em><strong>Personagem não pertence a sua conta</strong></em>, atualize a página e tente novamente")->flash();
            return null;
        }

        if ($this->loggedaccountgame()) {
            $this->messageuser()->class("error")->text("Deslogue sua <em><strong>conta no jogo</strong></em>, para continuar")->flash();
            return null;
        }

        $account = $this->table("MEMB_INFO")->columns("" . config['column_vip'] . " as vip")->where("memb___id = :mi", "mi={$this->sessionuser()->useraccount}")->get();
        if ($account->vip == 0) {
            $this->messageuser()->class("error")->text("Sua conta não tem <em><strong>Previlégio</strong></em>, veja mais em informações")->flash(true);
            return null;
        }

        if ($block < 0 || $block > 3) {
            $this->messageuser()->class("error")->text("Opção inválida, tente novamente.")->flash(true);
            return null;
        }

        $this->table("Character")->where("AccountID =:acc AND Name = :name", "acc={$this->sessionuser()->useraccount}&name={$char}")->updated([
            "Bloc_Profile" => $block
        ]);
        $this->messageuser()->class("success")->text("Perfil bloqueado com sucesso")->flash(true, true);
        $this->geratetokencsrf();

    }
}
