<?php

namespace Amwdeveloper\controller;

abstract class connection
{
    private $pdo;
    private $host = connection['host'];
    private $port = connection['port'];
    private $user = connection['user'];
    private $pass = connection['password'];
    private $db = connection['database'];
    private $driver = connection['driver'];

    public function db()
    {
        if (empty($this->pdo)) {
            try {
                if($this->driver == "sqlsrv") {
                    $this->pdo = new \PDO("sqlsrv:server={$this->host};database={$this->db}", $this->user, $this->pass);
                } elseif($this->driver == "dblib") {
                    $this->pdo = new \PDO("dblib:host={$this->host}:{$this->port};dbname={$this->db}", $this->user, $this->pass);
                }
                $this->pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
                $this->pdo->setAttribute(\PDO::ATTR_CASE, \PDO::CASE_NATURAL);
                $this->pdo->setAttribute(\PDO::ATTR_DEFAULT_FETCH_MODE, \PDO::FETCH_OBJ);
                $this->pdo->setAttribute(\PDO::ATTR_ORACLE_NULLS, \PDO::NULL_EMPTY_STRING);
            } catch (\PDOException $e) {
                echo $e->getMessage();
            }
        }
        return $this->pdo;
    }
}
