<?php

namespace Amwdeveloper\core;

use Amwdeveloper\model\{layer, message};
use League\Plates\Engine;
use PHPMailer\PHPMailer\{PHPMailer, Exception};

class email extends layer
{
    private $mail;
    private $host;
    private $username;
    private $passwd;
    private $port;
    private $view;
    // user
    private $address;
    private $name;
    private $account;
    private $upass;

    public function __construct()
    {
        $this->view = new Engine(__DIR__ . "/../../theme/" . config['path'] . "/pages", 'phtml');
    }

    public function index()
    {
        $title = config['web_title'] . '- Recuperar senha';
        echo $this->view->render('partials/mail/recover', ['title' => $title]);
    }

    public function sendmail($request)
    {
        $email = filter_var($request['email'], FILTER_VALIDATE_EMAIL);
        $message = new message();

        // if (requests_form("mail_error", 5, 10)) {
        //     $message->class("error")->text("Você efetuou 5 tentantivas, aguarde <em><strong>10 minutos</strong></em>")->flash();
        //     return null;
        // }

        if (!$email) {
            $message->class("error")->text("Preecha o campo email corretamente")->flash();
            return null;
        }

        $infoaccount = $this->table("MEMB_INFO")->columns("memb___id,memb__pwd,memb_name,mail_addr")->where("mail_addr = :m", "m={$email}")->get();

        if (!$infoaccount) {
            $message->class("error")->text("Este email não existe")->flash();
            return null;
        }


        $this->mail = new PHPMailer(true);
        $this->host = email['host'];
        $this->username = email['username'];
        $this->passwd = email['password'];;
        $this->port = email['port'];

        $this->address = $infoaccount->mail_addr;
        $this->name = $infoaccount->memb_name;
        $this->account = $infoaccount->memb___id;
        $this->upass = $infoaccount->memb__pwd;


        $this->send();
    }

    private function settings()
    {
        $this->mail->SMTPDebug = false;
        $this->mail->isSMTP();
        $this->mail->Host = $this->host;
        $this->mail->SMTPAuth = true;
        $this->mail->Username = $this->username;
        $this->mail->Password = $this->passwd;
        $this->mail->SMTPSecure = "tls";
        $this->mail->Port = $this->port;
        $this->mail->CharSet = 'UTF-8';

        return $this;
    }

    private function recipients()
    {
        $this->mail->setFrom(email['email'], server['name']);
        $this->mail->addAddress($this->address, $this->name);

        return $this;
    }

    private function ishtml()
    {
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Recuperação de conta ' . server['name'];
        $this->mail->Body = "
            <p style='padding: 5px 10px;'><strong>Login:</strong> {$this->account}</p>
            <p style='padding: 5px 10px;'><strong>Password:</strong> {$this->upass}</p>
            <hr>
            <p style='padding: 10px; font-size: 11px; color: #333'>Solicitação de recuperação de conta feita pelo ip: " . $_SERVER['REMOTE_ADDR'] . "
            <br>
            Data: " . date('d/m/Y H:i:s') . "
            </p>
        ";
        return $this;
    }

    protected function send()
    {
        $message = new message();
        try {
            $this->settings()->recipients()->ishtml();
            $this->mail->send();
            $message->class("success")->text("Dados enviados com sucesso")->flash();
        } catch (Exception $e) {
            var_dump($e->getMessage());
            $message->class("error")->text("Não foi possível recuperar seus dados no momento")->flash();
        }
    }
}
