<?php

namespace Amwdeveloper\core;

use Amwdeveloper\model\layer;

class geral extends layer
{

    public function staffs()
    {
        $staffs = $this->columns("c.Name as name, ms.ConnectStat as status, ac.GameIDC as gameidc")
            ->inner("Character c LEFT JOIN AccountCharacter ac ON ac.Id = c.AccountID LEFT JOIN MEMB_STAT ms ON ms.memb___id = ac.Id")
            ->where("CtlCode >= :cl", "cl=8")->all();

        if ($staffs) {
            $liststaffs = array();
            foreach ($staffs as $staff) {
                $liststaffs[] = [
                    'name' => $staff->name,
                    'status' => ($staff->name == $staff->gameidc and $staff->status == 1) ? 'online' : 'offline'
                ];
            }
            return $liststaffs;
        }
        return null;
    }

    public function playersonline()
    {
        return $this->table("MEMB_STAT")->where("ConnectStat = :cs", "cs=1")->count()->amount;
    }

    public function accounts()
    {
        return $this->table("MEMB_INFO")->count()->amount;
    }

    public function accountsVip()
    {
        return $this->table("MEMB_INFO")->where("AccountLevel != :cs", "cs=0")->count()->amount;
    }
    public function accountsBanned()
    {
        return $this->table("MEMB_INFO")->where("bloc_code = :cs", "cs=1")->count()->amount;
    }


    public function downloadall()
    {
        $download = $this->table("amw_download")->orderby('id')->all();
        if ($download) {
            foreach ($download as $down) {
                $list[] = [
                    'name' => $down->title,
                    'date' => date("d/m/Y", strtotime($down->date)),
                    'url' => $down->link,
                    'size' => $down->size,
                    'desc' => $down->description
                ];
            }
            return $list;
        }
        return null;
    }
}
