<?php

namespace Amwdeveloper\core;


class session
{
    public function __construct()
    {
        if (!session_id()) {
            session_start();
        }
    }

    public function __get($name)
    {
        return ($_SESSION[$name] ?? null);
    }

    public function __isset($name)
    {
        return $this->has($name);
    }

    public function set($key, $value): session
    {
        $_SESSION[$key] = (is_array($value) ? (object)$value : $value);
        return $this;
    }

    public function has($key): bool
    {
        return isset($_SESSION[$key]);
    }

    public function unset($key): session
    {
        unset($_SESSION[$key]);
        return $this;
    }

    public function destroy(): session
    {
        session_destroy();
        return $this;
    }
}
