<?php
/**
 * ============================================================
 * Helpers Gerais - Compatível com Tema "Purple"
 * ============================================================
 */

if (!function_exists('__')) {
    function __($text)
    {
        return $text;
    }
}

if (!function_exists('__resources')) {
    function __resources($path = '')
    {
        $theme = 'purple';
        return "/theme/{$theme}/resources/" . ltrim($path, '/');
    }
}

if (!function_exists('__files')) {
    function __files($path = '')
    {
        return "/files/" . ltrim($path, '/');
    }
}

if (!function_exists('__redirect')) {
    function __redirect($path = '')
    {
        return "/" . ltrim($path, '/');
    }
}

if (!function_exists('__dateFormat')) {
    function __dateFormat($date)
    {
        if (empty($date)) return '';
        $time = strtotime($date);
        return $time ? date('d/m/Y', $time) : $date;
    }
}

if (!function_exists('__guildmark')) {
    function __guildmark($data, $size = 64)
    {
        $src = "/guildmark/" . ltrim($data, '/');
        return "<img src='{$src}' width='{$size}' height='{$size}' alt='Guild Mark'>";
    }
}

if (!function_exists('plugin')) {
    function plugin()
    {
        return (object) [
            'slider' => true,
            'notices' => true,
            'hallfame' => true,
            'hallfame_events' => true,
            'castle_siege' => true,
            'market' => true,
        ];
    }
}

if (!function_exists('web')) {
    function web()
    {
        return (object) [
            'ranking_home' => 'default',
            'ranking_home_events' => 'default',
        ];
    }
}
