<?php

namespace Amwdeveloper\plugins\hallfame;

use Amwdeveloper\model\layer;

class home extends layer
{
    public function render()
    {
        if (ranking_home['type'] == 'box') {
            if (!empty(ranking_home['rankings'])) {
                $data = array();
                $title = array();
                foreach (ranking_home['rankings'] as $ranking) {
                    if ($ranking['table'] == 'Character') {
                        $query = $this->table($ranking['table'])
                            ->columns("Name as name,cLevel as level, Imagem as imagem," . $ranking['column'] . " as score")
                            ->limit(1)
                            ->orderby($ranking['column'])
                            ->get();

                        $data[] = array(
                            "name" => $query->name,
                            "level" => $query->level,
                            "imagem" => $query->imagem,
                            "score" => $query->score,
                            "type" => 'char',
                            "tag_name" => $ranking['tag_name'],
                            "title" => $ranking['title']
                        );
                    }
                    if ($ranking['table'] == 'Guild') {
                        $query = $this->table($ranking['table'])
                            ->columns("G_Name as name,G_Master as master, G_Mark as imagem," . $ranking['column'] . " as score")
                            ->limit(1)
                            ->orderby($ranking['column'])
                            ->get();

                        $data[] = array(
                            "guild" => $query->name,
                            "master" => $query->master,
                            "imagem" => $query->imagem,
                            "score" => $query->score,
                            "type" => 'guild',
                            "tag_name" => $ranking['tag_name'],
                            "title" => $ranking['title']
                        );
                    }

                    if ($ranking['table'] != 'Guild' and $ranking['table'] != 'Character') {
                        $query = $this->columns("c.Name as name,c.cLevel as level, c.Imagem as imagem,r." . $ranking['column'] . " as score")
                            ->inner("Character c LEFT JOIN " . $ranking['table'] . " r ON r.Name = c.Name")
                            ->limit(1)
                            ->orderby($ranking['column'])
                            ->get();
                        $data[] = array(
                            "name" => $query->name,
                            "level" => $query->level,
                            "imagem" => $query->imagem,
                            "score" => $query->score,
                            "type" => 'char',
                            "tag_name" => $ranking['tag_name'],
                            "title" => $ranking['title']
                        );
                    }
                }
                return ['rankings' => $data];
            }
        }

        if (ranking_home['type'] == 'box-five' or ranking_home['type'] == 'table') {
            if (!empty(ranking_home['rankings'])) {
                $result = array();
                foreach (ranking_home['rankings'] as $ranking) {
                    $setRanking = array();
                    if ($ranking['table'] == 'Character') {
                        $queryf = $this->table($ranking['table'])
                            ->columns("Name as name,cLevel as level, Imagem as imagem,Strength,Dexterity,Vitality,Energy," . $ranking['column'] . " as score")
                            ->limit(5)
                            ->where("CtlCode = :c","c=0")
                            ->orderby($ranking['column'])
                            ->all();
                    }

                    if ($ranking['table'] == 'Guild') {
                        $queryf = $this->table($ranking['table'])
                            ->columns("G_Name as name,G_Master as master, G_Mark as imagem," . $ranking['column'] . " as score")
                            ->limit(5)
                            ->orderby($ranking['column'])
                            ->all();
                    }

                    if ($ranking['table'] != 'Guild' and $ranking['table'] != 'Character') {
                        $queryf = $this->columns("c.Name as name,c.cLevel as level, c.Imagem as imagem,c.Strength,c.Dexterity,c.Vitality,c.Energy,r." . $ranking['column'] . " as score")
                            ->inner("Character c LEFT JOIN " . $ranking['table'] . " r ON r.Name = c.Name")
                            ->limit(5)
                            ->where("CtlCode = :c","c=0")
                            ->orderby($ranking['column'])
                            ->all();
                    }

                    foreach ($queryf as $query) {
                        if ($ranking['table'] != 'Guild') {
                            $setRanking[] = [
                                "name" => $query->name,
                                "level" => $query->level,
                                "imagem" => $query->imagem,
                                "score" => $query->score ?? 0,
                                "type" => 'char',
                                "strength" => $query->Strength,
                                "dexterity" => $query->Dexterity,
                                "vitality" => $query->Vitality,
                                "energy" => $query->Energy,
                                "tag_name" => ucfirst($ranking['tag_name'])
                            ];
                        } else {
                            $members = $this->table("GuildMember")->where("G_Name = :gname", "gname={$query->name}")->count();
                            $setRanking[] = array(
                                "guild" => $query->name,
                                "master" => $query->master,
                                "imagem" => $query->imagem,
                                "score" => $query->score,
                                'members' => $members->amount,
                                "type" => 'guild',
                                "tag_name" => ucfirst($ranking['tag_name'])
                            );
                        }
                    }

                    $result[] = [
                        'title' => $ranking['title'],
                        'ranking' => $setRanking,
                        'tag_game' => ucfirst($ranking['tag_name'])
                    ];
                }

                return $result;
            }
        }
    }

    public function renderevents()
    {
        if (ranking_home_events['type'] == 'box') {
            if (!empty(ranking_home_events['rankings'])) {
                $data = array();
                $title = array();
                foreach (ranking_home_events['rankings'] as $ranking) {
                    if ($ranking['table'] == 'Character') {
                        $query = $this->table($ranking['table'])
                            ->columns("Name as name,cLevel as level, Imagem as imagem," . $ranking['column'] . " as score")
                            ->limit(1)
                            ->where("CtlCode = :c","c=0")
                            ->orderby($ranking['column'])
                            ->get();

                        $data[] = array(
                            "name" => $query->name,
                            "level" => $query->level,
                            "imagem" => $query->imagem,
                            "score" => $query->score,
                            "type" => 'char',
                            "tag_name" => $ranking['tag_name'],
                            "title" => $ranking['title']
                        );
                    }
                    if ($ranking['table'] == 'Guild') {
                        $query = $this->table($ranking['table'])
                            ->columns("G_Name as name,G_Master as master, G_Mark as imagem," . $ranking['column'] . " as score")
                            ->limit(1)
                            ->orderby($ranking['column'])
                            ->get();

                        $data[] = array(
                            "guild" => $query->name,
                            "master" => $query->master,
                            "imagem" => $query->imagem,
                            "score" => $query->score,
                            "type" => 'guild',
                            "tag_name" => $ranking['tag_name'],
                            "title" => $ranking['title']
                        );
                    }

                    if ($ranking['table'] != 'Guild' and $ranking['table'] != 'Character') {
                        $query = $this->columns("c.Name as name,c.cLevel as level, c.Imagem as imagem,r." . $ranking['column'] . " as score")
                            ->inner("Character c LEFT JOIN " . $ranking['table'] . " r ON r.Name = c.Name")
                            ->limit(1)
                            ->where("CtlCode = :c","c=0")
                            ->orderby($ranking['column'])
                            ->get();
                        $data[] = array(
                            "name" => $query->name,
                            "level" => $query->level,
                            "imagem" => $query->imagem,
                            "score" => $query->score,
                            "type" => 'char',
                            "tag_name" => $ranking['tag_name'],
                            "title" => $ranking['title']
                        );
                    }
                }
                return ['rankings' => $data];
            }
        }

        if (ranking_home_events['type'] == 'box-five' or ranking_home_events['type'] == 'table') {
            if (!empty(ranking_home_events['rankings'])) {
                $result = array();
                foreach (ranking_home_events['rankings'] as $ranking) {
                    $setRanking = array();
                    if ($ranking['table'] == 'Character') {
                        $queryf = $this->table($ranking['table'])
                            ->columns("Name as name,cLevel as level, Imagem as imagem,Strength,Dexterity,Vitality,Energy," . $ranking['column'] . " as score")
                            ->limit(5)
                            ->where("CtlCode = :c","c=0")
                            ->orderby($ranking['column'])
                            ->all();
                    }

                    if ($ranking['table'] == 'Guild') {
                        $queryf = $this->table($ranking['table'])
                            ->columns("G_Name as name,G_Master as master, G_Mark as imagem," . $ranking['column'] . " as score")
                            ->limit(5)
                            ->orderby($ranking['column'])
                            ->all();
                    }

                    if ($ranking['table'] != 'Guild' and $ranking['table'] != 'Character') {
                        $queryf = $this->columns("c.Name as name,c.cLevel as level, c.Imagem as imagem,c.Strength,c.Dexterity,c.Vitality,c.Energy,r." . $ranking['column'] . " as score")
                            ->inner("Character c LEFT JOIN " . $ranking['table'] . " r ON r.Name = c.Name")
                            ->limit(5)
                            ->where("CtlCode = :c","c=0")
                            ->orderby($ranking['column'])
                            ->all();
                    }

                    foreach ($queryf as $query) {
                        if ($ranking['table'] != 'Guild') {
                            $setRanking[] = [
                                "name" => $query->name,
                                "level" => $query->level,
                                "imagem" => $query->imagem,
                                "score" => $query->score ?? 0,
                                "type" => 'char',
                                "strength" => $query->Strength,
                                "dexterity" => $query->Dexterity,
                                "vitality" => $query->Vitality,
                                "energy" => $query->Energy,
                                "tag_name" => ucfirst($ranking['tag_name'])
                            ];
                        } else {
                            $members = $this->table("GuildMember")->where("G_Name = :gname", "gname={$query->name}")->count();
                            $setRanking[] = array(
                                "guild" => $query->name,
                                "master" => $query->master,
                                "imagem" => $query->imagem,
                                "score" => $query->score,
                                'members' => $members->amount,
                                "type" => 'guild',
                                "tag_name" => ucfirst($ranking['tag_name'])
                            );
                        }
                    }

                    $result[] = [
                        'title' => $ranking['title'],
                        'ranking' => $setRanking,
                        'tag_game' => ucfirst($ranking['tag_name'])
                    ];
                }

                return $result;
            }
        }
    }

    public function castlesiege()
    {
        $guild = $this->table("MuCastle_DATA")->columns("OWNER_GUILD as owner, SIEGE_START_DATE as start, SIEGE_END_DATE as finish")->orderby("MAP_SVR_GROUP")->get();
        if ($guild) {
            $master = $this->table("Guild")->columns("G_Mark as mark,G_Master as master")->where("G_Name = :gn", "gn={$guild->owner}")->get();
            return (object)[
                'guild' => $guild->owner ?? null,
                'master' => $master->master ?? null,
                'mark' => $master->mark ?? null,
                'start' => $guild->start ?? null,
                'finish' => $guild->finish ?? null,
                'next_confront' => castle_siege['next_confront'] ?? null,
                'message' => castle_siege['message'] ?? null,
            ];
        }
    }
}
