<?php

namespace Amwdeveloper\plugins\market\character;

use Amwdeveloper\core\details;
use Amwdeveloper\model\layer;

class inventory extends layer
{
    public $Vault_Content;
    public $Vault_Slots = array();
    public $Varbinary = null;
    public $LineCounts = null;
    public $SlotCounts = null;
    public $Character;
    public $divisor;
    public $description;
    private $servertype;

    function __construct($name)
    {
        $getLenghts = $this->db()->query("SELECT [length] FROM [syscolumns] WHERE OBJECT_NAME([id]) = 'Character' AND [name] = 'Inventory';")->fetch();
        $this->Varbinary = $getLenghts->length;
        $this->LineCounts = (($getLenghts->length * 2) / (web_shopping['db_version'] == 1 ? 20 : 32)) / 8;
        $this->SlotCounts = (($getLenghts->length * 2) / (web_shopping['db_version'] == 1 ? 20 : 32));

        $query = $this->db()->query("SELECT Inventory FROM Character WHERE Name = '{$name}' ")->fetch();

        $this->Vault_Content = bin2hex($query->Inventory);

        if (web_shopping['db_version'] == 1) {
            $this->divisor = 20;
            $this->servertype = 'OLD';
        } else {
            $this->divisor = 32;
            $this->servertype = 'NEW';
        }
    }

    public function slotInventory()
    {
        $i = (int) 0;
        for ($Line = 0; $Line < $this->LineCounts; $Line++) {
            for ($Column = 0; $Column < 8; $Column++) {
                $this->Vault_Slots[$i / $this->divisor]['Hex'] = substr($this->Vault_Content, $i, $this->divisor);
                $this->Vault_Slots[$i / $this->divisor]['Line'] = $Line;
                $this->Vault_Slots[$i / $this->divisor]['Column'] = $Column;
                $i += $this->divisor;
            }
        }
        return $this->Vault_Slots;
    }

    public function ReverseBits($b)
    {
        switch (strtoupper(substr($b, 0, 1))) {
            case "0":
                return "0000";
            case "1":
                return "0001";
            case "2":
                return "0010";
            case "3":
                return "0011";
            case "4":
                return "0100";
            case "5":
                return "0101";
            case "6":
                return "0110";
            case "7":
                return "0111";
            case "8":
                return "1000";
            case "9":
                return "1001";
            case "A":
                return "1010";
            case "B":
                return "1011";
            case "C":
                return "1100";
            case "D":
                return "1101";
            case "E":
                return "1110";
            case "F":
                return "1111";
        }
    }

    public function Bit3Reverse($bits)
    {
        switch ($bits) {
            case "000":
                return 0;
            case "001":
                return 1;
            case "010":
                return 2;
            case "011":
                return 3;
            case "100":
                return 4;
            case "101":
                return 5;
            case "110":
                return 6;
            case "111":
                return 7;
            case "000":
                return 8;
            case "001":
                return 9;
            case "010":
                return 10;
            case "011":
                return 11;
            case "100":
                return 12;
            case "101":
                return 13;
            case "110":
                return 14;
            case "111":
                return 15;
            case "000":
                return 16;
            case "001":
                return 17;
            case "010":
                return 18;
            case "011":
                return 19;
            case "100":
                return 20;
            case "101":
                return 21;
            case "110":
                return 22;
            case "111":
                return 23;
            case "000":
                return 24;
            case "001":
                return 25;
            case "010":
                return 26;
            case "011":
                return 27;
            case "100":
                return 28;
            case "101":
                return 29;
            case "110":
                return 30;
        }
    }

    public function Bit5Reverse($bits)
    {
        switch ($bits) {
            case "00000":
                return 0;
            case "00001":
                return 1;
            case "00010":
                return 2;
            case "00011":
                return 3;
            case "00100":
                return 4;
            case "00101":
                return 5;
            case "00110":
                return 6;
            case "00111":
                return 7;
            case "01000":
                return 8;
            case "01001":
                return 9;
            case "01010":
                return 10;
            case "01011":
                return 11;
            case "01100":
                return 12;
            case "01101":
                return 13;
            case "01110":
                return 14;
            case "01111":
                return 15;
            case "10000":
                return 16;
            case "10001":
                return 17;
            case "10010":
                return 18;
            case "10011":
                return 19;
            case "10100":
                return 20;
            case "10101":
                return 21;
            case "10110":
                return 22;
            case "10111":
                return 23;
            case "11000":
                return 24;
            case "11001":
                return 25;
            case "11010":
                return 26;
            case "11011":
                return 27;
            case "11100":
                return 28;
            case "11101":
                return 29;
            case "11110":
                return 30;
            case "11111":
                return 31;
        }
    }

    public function GetItemId($id)
    {
        $bin1 = $this->ReverseBits(strtoupper(substr($id, 0, 1)));
        $bin2 = $this->ReverseBits(strtoupper(substr($id, 1, 1)));
        $bin = $bin1 . $bin2;
        return array('section' => $this->Bit3Reverse(substr($bin, 0, 3)), 'index' => $this->Bit5Reverse(substr($bin, 3, 5)));
    }

    public function CutHexSlotsInventory()
    {
        $list = [];
        for ($i = 0; $i < 12; $i++) {
            if (strtoupper($this->slotInventory()[$i]['Hex']) != str_pad("", $this->divisor, "F") && $this->slotInventory()[$i]['Hex'] != str_pad("", $this->divisor, "0") && $this->slotInventory()[$i]['Hex'] <> NULL) {

                if ($this->servertype == "NEW") {
                    $Categorie = hexdec(substr($this->Vault_Slots[$i]['Hex'], 18, 1));
                    $Index = hexdec(substr($this->Vault_Slots[$i]['Hex'], 0, 2));
                    $durabillity = hexdec(substr($this->Vault_Slots[$i]['Hex'], 4, 2));
                    $level = hexdec(substr($this->Vault_Slots[$i]['Hex'], 2, 2));
                    $excelents = hexdec(substr($this->Vault_Slots[$i]['Hex'], 14, 2));
                    $Ancient = hexdec(substr($this->Vault_Slots[$i]['Hex'], 16, 2));
                    $harmony = hexdec(substr($this->Vault_Slots[$i]['Hex'], 20, 2));
                    $item360 = hexdec(substr($this->Vault_Slots[$i]['Hex'], 18, 2));
                    $socket1 = hexdec(substr($this->Vault_Slots[$i]['Hex'], 22, 2));
                    $socket2 = hexdec(substr($this->Vault_Slots[$i]['Hex'], 24, 2));
                    $socket3 = hexdec(substr($this->Vault_Slots[$i]['Hex'], 26, 2));
                    $socket4 = hexdec(substr($this->Vault_Slots[$i]['Hex'], 28, 2));
                    $socket5 = hexdec(substr($this->Vault_Slots[$i]['Hex'], 30, 2));

                    $FindItemDetails = $this->db()->query("SELECT * FROM amw_items WHERE id_item = '{$Index}' AND section = '{$Categorie}'")->fetch(\PDO::FETCH_OBJ);

                    $this->description = details::descriptionitem(
                        $FindItemDetails,
                        $Categorie,
                        $Index,
                        $level,
                        $excelents,
                        $durabillity,
                        $Ancient,
                        $harmony,
                        $item360,
                        $socket1,
                        $socket2,
                        $socket3,
                        $socket4,
                        $socket5
                    );
                }
                switch ($i) {
                    case 0:
                        $class = 'sword';
                        break;
                    case 1:
                        $class = 'shield';
                        break;
                    case 2:
                        $class = 'helm';
                        break;
                    case 3:
                        $class = 'armor';
                        break;
                    case 4:
                        $class = 'pants';
                        break;
                    case 5:
                        $class = 'gloves';
                        break;
                    case 6:
                        $class = 'boots';
                        break;
                    case 7:
                        $class = 'wing';
                        break;
                    case 8:
                        $class = 'pet';
                        break;
                    case 9:
                        $class = 'pendant';
                        break;
                    case 10:
                        $class = 'ring_1';
                        break;
                    case 11:
                        $class = 'ring_2';
                        break;
                        return $class;
                }

                $list[] = [
                    "class" => $class,
                    "details" => $FindItemDetails,
                    "description" => $this->description
                ];
            }
        }

        return $list;
    }
}
