<?php

namespace Amwdeveloper\plugins\market\character;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;
use League\Plates\Engine;

class view extends geral
{

    private $route;
    private $view;
    private $title_web;
    private $session;
    private $message;

    public function __construct()
    {
        global $route;
        $this->view = new Engine(__DIR__ . "/../../../../theme/" . config['path'] . "/pages", 'phtml');
        $this->route = $route;
        $this->title_web = config['web_title'];
        $this->session = new session();
        $this->message = new message();
        if (!$this->session->has("useraccount")) {
            return $this->route->redirect("/");
        }
    }

    public function selectChar()
    {
        echo $this->view->render('user/market/character/select_char', [
            'title' => $this->title_web . ' -  Meus personagens',
            'characters' => $this->myCharacters()
        ]);
    }

    public function advertiseChar($char)
    {
        $char = filter_var($char['char'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (!$char)  return $this->route->redirect("/market/my/characters");

        $virifychar = $this->table("Character")
            ->where("Name = :name AND AccountID = :acc AND CtlCode = :c", "name={$char}&acc=" . $this->session->useraccount . "&c=0")
            ->get();

        if (!$virifychar)  return $this->route->redirect("/market/my/characters");

        echo $this->view->render('user/market/character/advertise_char', [
            'title' => $this->title_web . ' -  anunciar personagem',
            'character' => $this->myCharacter($char),
            'inventory' => $this->inventoryCharacter($char)
        ]);
    }

    public function storeCharacter()
    {
        $stores = $this->table("amw_market_character")->where("account = :acc", "acc=" . (new session)->useraccount . "")->all();

        echo $this->view->render('user/market/character/store', [
            'title' => $this->title_web . ' -  lista de anuncios',
            'stores' => $stores ?? null,
        ]);
    }

    public function deleteCharacter($char)
    {
        $id = filter_var($char['id'], FILTER_VALIDATE_INT);

        if (!$id)
            return $this->route->redirect("/market/store/characters");

        if (!$this->removeCharacter($id))
            return $this->route->redirect("/market/store/characters");
        return $this->route->redirect("/market/store/characters");
    }

    public function viewCharacters()
    {
        $items = $this->table("amw_market_character")->orderby("price")->all();

        echo $this->view->render('user/market/character/listall', [
            'title' => $this->title_web . ' -  Todos os personagens do mercado',
            'title_section' => "dasdas",
            'items' => $items
        ]);
    }

    public function viewCharactersClass($class)
    {
        $class = filter_var($class['class'], FILTER_SANITIZE_SPECIAL_CHARS);

        $items = $this->table("amw_market_character")->where("class = :c", "c={$class}")->orderby("price")->all();


        $item = $this->table("amw_market_character")->where("class = :c", "c={$class}")->get();
        if ($item) $nameClass = characters['classes'][$item->n_class]['name'];
        else $nameClass = '...';

        echo $this->view->render('user/market/character/section', [
            'title' => $this->title_web . ' -  Todos os personagens do mercado',
            'title_section' => "dasdas",
            'items' => $items,
            'classe' => $nameClass
        ]);
    }

    public function viewDetailsCharacter($char)
    {
        $name = filter_var($char['name'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (!$name) return $this->route->redirect("/market/view/characters");
        $character = $this->table("amw_market_character")->where("name = :c", "c={$name}")->get();
        if (!$character) return $this->route->redirect("/market/view/characters");

        echo $this->view->render('user/market/character/details', [
            'title' => $this->title_web . ' -  Todos os personagens do mercado',
            'character' => $character,
            'inventory' => $this->inventoryCharacter($character->name)
        ]);
    }
}
