<?php

namespace Amwdeveloper\plugins\posts;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;

class postcomment extends layer
{
    public function comment($request)
    {
        $messagepost = new message();
        $session = new session();

        $id = filter_var($request['id'], FILTER_VALIDATE_INT);
        $message = filter_var($request['message'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (requests_form("fail_comment", 5, 15)) {
            $messagepost->class("error")->text("IP: {$_SERVER['REMOTE_ADDR']} bloqueado por <em><strong>15 minutos</strong></em>")->flash(true);
            return null;
        }

        if (empty($id)) {
            $messagepost->class("error")->text("Erro interno, <em><strong>atualize a página</strong></em>  e tente novamente")->flash();
            return null;
        }

        if (empty($message)) {
            $messagepost->class("error")->text("Campo, <em><strong>mensagem</strong></em>  está vázio")->flash(true);
            return null;
        }

        $verifyid = $this->table("amw_notice")->columns("comment")->where("id = :id", "id={$id}")->get();

        if (empty($verifyid)) {
            $messagepost->class("error")->text("Erro interno, <em><strong>atualize a página</strong> e tente novamente</em>")->flash();
            return null;
        }

        if ($verifyid->comment == 1) {
            $messagepost->class("error")->text("Está notícia está com os, <em><strong>comentários desativados</strong></em>")->flash();
            return null;
        }

        if (requests_form("comment_post", 2, 10)) {
            $messagepost->class("error")->text("Você comentou recentemente, aguarde <em><strong>10 minutos</strong></em>")->flash();
            return null;
        }

        $account = $this->table("MEMB_INFO")->columns("memb_name")->where("memb___id = :mi", "mi={$session->useraccount}")->get();
        $addcomment = [
            'message' => $message,
            'account' => $account->memb_name,
            'date' => date('Y-m-d H:i:s', strtotime("now")),
            'id_notice' => $id
        ];

        $this->table("amw_notice_comments")->created($addcomment);
        $messagepost->class("success")->text("<em><strong>Comentário</strong></em> adicionado com sucesso")->flash(true, true);
    }
}
