<?php

namespace Amwdeveloper\plugins\sliders;

use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;
use Cocur\Slugify\Slugify;

class admin extends layer
{
    public $message;
    public function __construct()
    {
        $this->message = new message();
    }

    public function authaddnewslider($request)
    {
        $title = filter_var($request['title'], FILTER_SANITIZE_SPECIAL_CHARS);

        $image = $_FILES['image'];

        if (empty($image['name'])) {
            $this->message->class("error")->text("Selecione uma <em><strong>imagem</strong></em> para continuar")->flash();
            return null;
        }

        $extesion = array("image/jpg", "image/jpeg", "image/png", "image/gif");

        if (in_array($image['type'], $extesion)) {
            $resource = __DIR__ . '/../../../resource/slider/';
            $newname = md5(uniqid()) . mb_strrchr($image['name'], ".");
            $temp = $image['tmp_name'];

            if (move_uploaded_file($temp, $resource . $newname)) {
                $insert = [
                    'title' => $title ?? null,
                    'image' => $newname
                ];
                $this->table("amw_slider")->created($insert);
                $this->message->class("success")->text(" <em><strong>Slider</strong></em> adicionado com sucesso")->flash(true, true);
                return null;
            }
        } else {
            $this->message->class("error")->text("<em><strong>Extenção da imagem</strong></em> inválida")->flash();
            return null;
        }
    }
}
