<?php

namespace Amwdeveloper\plugins\store;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;
use League\Plates\Engine;

class view
{

    private $route;
    private $view;
    private $title_web;
    private $session;
    private $message;

    public function __construct()
    {
        global $route;
        $this->view = new Engine(__DIR__ . "/../../../theme/" . config['path'] . "/pages", 'phtml');
        $this->route = $route;
        $this->title_web = config['web_title'];
        $this->session = new session();
        $this->message = new message();
    }

    public function index()
    {
        if (!$this->session->has("useraccount")) {
            return $this->route->redirect("/");
        }

        echo $this->view->render('partials/store/index', [
            'title' => $this->title_web . ' -  Loja',
        ]);
    }

    public function buyPackage($data)
    {
        $id = filter_var($data['id'], FILTER_SANITIZE_SPECIAL_CHARS);
        if (!$id or !$package = packages[$id]) {
            $this->message->class("error")->text("Pacote não existe, atualize a página e tente novamente!")->flash();
            return;
        }

        $session = new session();

        if (!$session->has('useraccount')) {
            (new message())->class("error")->text("Você precista estar <strong>logado em sua conta</strong> para continuar sua compra.")->flash();
            return;
        }

        $layer = new layer();
        $account = $layer->db()->query("SELECT " . coin_remove['column_coin'] . " as coin FROM  " . coin_remove['table'] . " WHERE " . coin_remove['column_account'] . " = '{$session->useraccount}'")->fetch();

        if ($account->coin < $package['price']) {
            (new message())->class("error")->text("Você não possuí a quantidade de <strong>{$package['price']} " . coin_remove['name_coin'] . "</strong>.")->flash();
            return;
        }

        if ($package['items']['active']) {
            $items = $layer->db()->query("SELECT Items FROM warehouse WHERE AccountID = '{$session->useraccount}' ")->fetch();

            if (preg_match("/[abcdeghijklmnopqrstuwxyzABCDEGHIJKLMNOPQRSTUWXYZ]/", strtoupper(bin2hex($items->Items)))) {
                (new message())->class("error")->text("Para a sua segurança, <strong>limpe seu Baú</strong> para continuar")->flash();
                return;
            }

            (new item())->addItemAccount($package['items']['list']);
        };

        if ($package['vip']['active']) (new item())->addVipAccount($package['vip']['details']);
        if ($package['coin']['active']) (new item())->addCoinAccount($package['coin']['details']);

        $layer->db()->query("UPDATE " . coin_remove['table'] . " SET " . coin_remove['column_coin'] . " = " . coin_remove['column_coin'] . " - " . $package['price'] . " WHERE " . coin_remove['column_account'] . " = '{$session->useraccount}'");

        (new message())->class("success")->text("<strong>Pacote comprado</strong> com sucesso")->flash(true, true);
    }
}
