<?php

namespace Amwdeveloper\plugins\webshop;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;

class kit extends layer
{

    public $infoitem;
    public $excelents;
    public $ancient;
    public $idx;
    public $idxkit;

    public function setid($id = null)
    {
        $this->idx = $id;
        return $this;
    }
    // KIT

    public function setidkit($id = null)
    {
        $this->idxkit = $id;
        return $this;
    }

    public function infokit()
    {
        $itemsPackage = $this->table("amw_items_kit")->where("id_package = :id", "id={$this->idxkit}")->limit(200)->all();
        $listitem = array();
        foreach ($itemsPackage as $items) {
            $itemverify = $this->table("amw_items_kit")
                ->columns("section,id_item,level,aditional,luck,skill,durability,excelent,ancient,harmony,socket1,socket2,socket3,socket4,socket5")
                ->where("id_package = :idp AND section = :s AND id_item = :id AND level = :level", "idp={$this->idxkit}&s={$items->section}&id={$items->id_item}&level={$items->level}")
                ->get();
            if (empty($itemverify)) return null;

            $iditems = $this->table("amw_items")->where("section = :sc AND id_item = :id", "sc={$items->section}&id={$items->id_item}")->get();

            if (web_shopping['db_version'] == 1) {
                $item_convert = $itemverify->id_item + ($itemverify->section  * 32);
                $item = (int)($item_convert % 256);
                $group = (int)($item_convert / 256);

                if ($group == 1) $this->excelents = 128;
            } else {
                $item = $itemverify->id_item;
            }
            $serial = str_pad(dechex(substr(rand(0, 9999999999), 0, 8)), 8, 0, STR_PAD_LEFT);

            $listitem[] = array(
                'item' => $item,
                'group' => $group ?? null,
                'serial' => $serial,
                'infoitem' => $itemverify,
                'id_items' => $iditems->id,
                'x' => $iditems->x,
                'y' => $iditems->y

            );
        }
        return $listitem ?? null;
    }


    public function geratehexkit($name, $table, $column_account, $coin_name, $price)
    {
        if ($this->infokit()) {
            $session = new session();
            $messages = new message();

            if (count($this->infokit()) > 1) {
                $items = $this->db()->query("SELECT Items FROM warehouse WHERE AccountID = '{$session->useraccount}' ")->fetch();
                if (preg_match("/[abcdeghijklmnopqrstuwxyzABCDEGHIJKLMNOPQRSTUWXYZ]/", strtoupper(bin2hex($items->Items)))) {
                    $messages->class("error")->text("Este all contém 2 itens ou mais, <em><strong>limpe seu Baú</strong></em> para continuar")->flash();
                    return;
                }
            }
            foreach ($this->infokit() as $item) {
                $this->excelents = 0;
                $this->ancient = 0;

                if (isset($item['group']) and $item['group'] == 1) $this->excelents = 128;
                $category = dechex($item['infoitem']->section);

                $levelitem = $item['infoitem']->level * 8;

                /** [Validando os Adicionais dos itens e somando ao level do item] */
                if ($item['infoitem']->aditional == 4 or $item['infoitem']->aditional  == 20) $levelitem += 1;
                if ($item['infoitem']->aditional == 8 or $item['infoitem']->aditional  == 24) $levelitem += 2;
                if ($item['infoitem']->aditional == 12 or $item['infoitem']->aditional == 28) $levelitem += 3;


                /** [Se o Adicionar for >= 16 então o excelentes recebe + 64] */
                if ($item['infoitem']->aditional >= 16) $this->excelents += 64;

                /** [Se existe Luck level recebe + 4 | se existe skill level recebe + 128] */
                if ($item['infoitem']->luck  == 1) $levelitem += 4;
                if ($item['infoitem']->skill == 1) $levelitem += 128;

                /** [Validando os excelentes do item] */
                if ($item['infoitem']->excelent >= 1) $this->excelents +=  1;
                if ($item['infoitem']->excelent >= 2) $this->excelents +=  2;
                if ($item['infoitem']->excelent >= 3) $this->excelents +=  4;
                if ($item['infoitem']->excelent >= 4) $this->excelents +=  8;
                if ($item['infoitem']->excelent >= 5) $this->excelents += 16;
                if ($item['infoitem']->excelent >= 6) $this->excelents += 32;

                if ($item['item'] >= 256 and $item['infoitem']->section > 13) $this->excelents = 128;
                if ($item['item'] >= 256 and $item['infoitem']->section <= 12) $this->excelents = 255;

                /** [Ancients do item] */
                if ($item['infoitem']->ancient == 1) $this->ancient = 5;
                elseif ($item['infoitem']->ancient == 2) $this->ancient = 10;
                else $this->ancient = 0;

                $hexaitem = ($item['item'] >= 256)
                    ? substr(dechex($item['item'] + 256), 1, 2)
                    : str_pad(dechex($item['item']), 2, 0, STR_PAD_LEFT);


                $durability = str_pad(dechex($item['infoitem']->durability), 2, 0, STR_PAD_LEFT);

                $excelents  = str_pad(dechex($this->excelents), 2, 0, STR_PAD_LEFT);

                $levelitem  = str_pad(dechex($levelitem), 2, 0, STR_PAD_LEFT);

                $ancient    = str_pad(dechex($this->ancient ?? 0), 2, 0, STR_PAD_LEFT);

                $harmony = str_pad(dechex($item['infoitem']->harmony ?? 0), 2, 0, STR_PAD_LEFT);

                $socket1    = str_pad(dechex($item['infoitem']->socket1 ?? 255), 2, 0, STR_PAD_LEFT);
                $socket2    = str_pad(dechex($item['infoitem']->socket2 ?? 255), 2, 0, STR_PAD_LEFT);
                $socket3    = str_pad(dechex($item['infoitem']->socket3 ?? 255), 2, 0, STR_PAD_LEFT);
                $socket4    = str_pad(dechex($item['infoitem']->socket4 ?? 255), 2, 0, STR_PAD_LEFT);
                $socket5    = str_pad(dechex($item['infoitem']->socket5 ?? 255), 2, 0, STR_PAD_LEFT);

                $hexa = (web_shopping['db_slotcount'] == 32 and web_shopping['db_version'] >= 2)
                    ? strtoupper($hexaitem . $levelitem . $durability . $item['serial'] . $excelents . $ancient . $category . '0' . $harmony . $socket1 . $socket2 . $socket3 . $socket4 . $socket5)
                    : strtoupper($hexaitem . $levelitem . $durability . $item['serial'] . $excelents . '00' . $ancient);

                (new vault())->hexvaultkit($item['x'], $item['y'], $hexa, $item['id_items']);
            }

            $this->db()->query("UPDATE {$table} SET {$coin_name} = {$coin_name} - {$price} WHERE {$column_account} = '{$session->useraccount}'");
            $messages->class("success")->text("<em><strong>{$name}</strong></em> comprado com sucesso")->flash(true, true);
        }
    }
}
