<?php

use CoffeeCode\Router\Router;

require __DIR__ . '/vendor/autoload.php';

$route = new Router(base_url);

$path = __DIR__ . '/routes';

$files = array_diff(scandir($path), ['.', '..', '...']);

foreach ($files as $file) {
    require $path . '/' . $file;
}


$route->group("error")->namespace('Amwdeveloper\view');
$route->get('/{error}', "web:error");

$route->dispatch();

if ($route->error()) {
    return $route->redirect("/");
}
