$("form").on("submit", function (e) {
  e.preventDefault();
  var form = $(this);
  var boxmessage = $(".web-alerts");
  var message = $(".web-alerts .message");
  var data = new FormData(form[0]);
  var url = form.attr("action");

  $.ajax({
    url: url,
    method: "post",
    data: data,
    processData: false,
    contentType: false,
    dataType: "json",
    beforeSend: function () {
      message.html(`
            <div class="preload">
            <div class="lds-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
            </div> 
            `);
      boxmessage.css({ visibility: "visible", opacity: 1 });
    },
    success: function (response) {
      if (response.message) {
        message.html(response.message);
        boxmessage.css({ visibility: "visible", opacity: 1 });

        var overlay = $('#overlay');
        var modal = $('.modal_div');

        modal
          .animate({ opacity: 0, top: '15%' }, 200,
            function () {
              $(this).css('display', 'none');
              overlay.fadeOut(400);
            }
          );
      }

      if (response.clear) {
        form.trigger("reset");
      }

      if (response.redirect) {
        setTimeout(() => {
          window.location.href = response.redirect
        }, 2000)
      }

      if (response.refresh) {
        setTimeout(() => {
          window.location.reload();
        }, 1000);
      }
    },
  });
});

$(".search_items").on("keyup", function (e) {
  var url = $(this).attr("action");
  var data = $(this).serialize();

  $.ajax({
    url: url,
    method: "post",
    data: data,
    beforeSend: function () {
      $(".result_items_market").html(`<div class="warning">Buscando itens...</div>`);
    },
    success: function (response) {
      $(".result_items_market").html(response);
    }
  })
})

$(function () {
  $(document).on("click", ".web-alerts .message a", function (e) {
    e.preventDefault();
    var boxmessage = $(".web-alerts");
    var message = $(".web-alerts .message");
    message.html("");
    boxmessage.css({ visibility: "hidden", opacity: 0 });
  });

  $(".item .action a").on("click", function (e) {
    e.preventDefault();

    var url = $(this).data("url");
    var name = $(this).data("name");
    var item = $(this).data("item");

    var html = `<p class="info">Deseja continuar com a compra do item: <em><strong>${name}</strong></em> ?</p>
        <div class="action d-flex j-center gap-40">
            <a href="javascript:void(0)" class="continue" data-url="${url}" data-name="${name}" data-item="${item}">Continuar</a>
            <a href="javascript:void(0)" class="canceled">Cancelar</a>
        </div>`;

    $(".web-alerts .message").html(html);
    $(".web-alerts").css({ visibility: "visible", opacity: 1 });
  });

  $(document).on("click", ".item-view .action a", function (e) {
    e.preventDefault();

    var url = $(this).data("url");
    var name = $(this).data("name");

    var html = `<p class="info">Deseja continuar com a compra do item: <em><strong>${name}</strong></em> ?</p>
        <div class="action d-flex j-center gap-40">
            <a href="javascript:void(0)" class="continue" data-url="${url}" data-name="${name}">Continuar</a>
            <a href="javascript:void(0)" class="canceled">Cancelar</a>
        </div>`;

    $(".web-alerts .message").html(html);
    $(".web-alerts").css({ visibility: "visible", opacity: 1 });
  });

  $(".packages .package a").on("click", function (e) {
    e.preventDefault();

    var url = $(this).data("url");
    var name = $(this).data("name");
    var id = $(this).data("id");

    var html = `<p class="info">Deseja continuar com a compra do pacote: <em><strong>${name}</strong></em> ?</p>
        <div class="action d-flex j-center gap-40">
            <a href="javascript:void(0)" class="continue" data-url="${url}" data-name="${name}" data-item="${id}">Continuar</a>
            <a href="javascript:void(0)" class="canceled">Cancelar</a>
        </div>`;

    $(".web-alerts .message").html(html);
    $(".web-alerts").css({ visibility: "visible", opacity: 1 });
  });

  $(document).on("click", ".continue", function (e) {
    e.preventDefault();

    var message = $(".web-alerts .message");
    var boxmessage = $(".web-alerts");
    var url = $(this).data("url");
    var name = $(this).data("name");
    var item = $(this).data("item");

    $.post({
      url: url,
      method: "post",
      data: { name: name, item: item },
      dataType: "json",
      beforeSend: function () {
        message.html(`
        <div class="preload">
        <div class="lds-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
        </div> 
                `);
        boxmessage.css({ visibility: "visible", opacity: 1 });
      },
      success: function (response) {
        if (response.message) {
          message.html(response.message);
          boxmessage.css({ visibility: "visible", opacity: 1 });
        }

        if (response.refresh) {
          setTimeout(() => {
            window.location.reload();
          }, 2000);
        }
      },
    });
  });

  $("#hallfame-geral .buttons a*").on("click", function (e) {
    e.preventDefault();
    var viewA = $(this).attr("view");
    var divrank = $("#hallfame-geral .ranking-view");
    $("#hallfame-geral  .buttons a*").removeClass("active");
    $(this).addClass("active");
    divrank.each((e, t) => {
      var divB = t.getAttribute("view");
      if (viewA == divB) t.style.display = "flex";
      else t.style.display = "none";
    });
  });

  $("#hallfame-events .buttons a*").on("click", function (e) {
    e.preventDefault();
    var viewA = $(this).attr("view");
    var divrank = $("#hallfame-events .ranking-view");
    $("#hallfame-events .buttons a*").removeClass("active");
    $(this).addClass("active");
    divrank.each((e, t) => {
      var divB = t.getAttribute("view");
      if (viewA == divB) t.style.display = "flex";
      else t.style.display = "none";
    });
  });


  $(document).on("click", ".closed-details", function (e) {
    e.preventDefault();
    $(".preview-information").css({ visibility: "hidden", opacity: 0 });
    $(".preview-information .details").html("");
  });

  $(".jewel-trade").on("click", function (e) {
    e.preventDefault();

    var url = $(this).data("url");
    var id = $(this).data("hex");

    var html = `<p class="info">Deseja continuar com a troca da jóia ?</p>
        <div class="action d-flex j-center gap-40">
            <a href="javascript:void(0)" class="continue_jewel" data-url="${url}" data-hex="${id}">Continuar</a>
            <a href="javascript:void(0)" class="canceled">Cancelar</a>
        </div>`;

    $(".web-alerts .message").html(html);
    $(".web-alerts").css({ visibility: "visible", opacity: 1 });
  });

  $(document).on("click", ".continue_jewel", function (e) {
    e.preventDefault();

    var message = $(".web-alerts .message");
    var boxmessage = $(".web-alerts");
    var url = $(this).data("url");
    var hex = $(this).data("hex");

    $.post({
      url: url,
      method: "post",
      data: { hex: hex },
      dataType: "json",
      beforeSend: function () {
        message.html(`
        <div class="preload">
        <div class="lds-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
        </div> 
                `);
        boxmessage.css({ visibility: "visible", opacity: 1 });
      },
      success: function (response) {
        if (response.message) {
          message.html(response.message);
          boxmessage.css({ visibility: "visible", opacity: 1 });
        }

        if (response.refresh) {
          setTimeout(() => {
            window.location.reload();
          }, 2000);
        }
      },
    });
  });

  $(".package-store").on("click", function (e) {
    e.preventDefault();

    var url = $(this).data("url");
    var id = $(this).data("id");

    var html = `<p class="info">Deseja continuar com a compra do pacote ?</p>
        <div class="action d-flex j-center gap-40">
            <a href="javascript:void(0)" class="continue_store" data-url="${url}" data-id="${id}">Continuar</a>
            <a href="javascript:void(0)" class="canceled">Cancelar</a>
        </div>`;

    $(".web-alerts .message").html(html);
    $(".web-alerts").css({ visibility: "visible", opacity: 1 });
  });

  $(document).on("click", ".continue_store", function (e) {
    e.preventDefault();

    var message = $(".web-alerts .message");
    var boxmessage = $(".web-alerts");
    var url = $(this).data("url");
    var id = $(this).data("id");

    $.post({
      url: url,
      method: "post",
      data: { id: id },
      dataType: "json",
      beforeSend: function () {
        message.html(`
        <div class="preload">
        <div class="lds-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
        </div> 
                `);
        boxmessage.css({ visibility: "visible", opacity: 1 });
      },
      success: function (response) {
        if (response.message) {
          message.html(response.message);
          boxmessage.css({ visibility: "visible", opacity: 1 });
        }

        if (response.refresh) {
          setTimeout(() => {
            window.location.reload();
          }, 2000);
        }
      },
    });
  });

});
