<?php

$route->group('administration')->namespace('Amwdeveloper\view');
$route->get("/account/login", "admin:accountlogin");
$route->get("/account/logout", "admin:accountlogout");
$route->get("/", "admin:index");
$route->get("/home", "admin:index");
$route->get('/new/download', "admin:newdownload");
$route->get('/manage/all/downloads', "admin:managealldownloads");
$route->get('/to/edit/download/{id}', "admin:toeditdownload");


/** Account */
$route->get('/account/add/coin', "admin:accountaddcoin");
$route->get('/account/remove/coin', "admin:accountremovecoin");
$route->get('/account/add/vip', "admin:accountaddvip");
$route->get('/account/remove/vip', "admin:accountremovevip");
$route->get('/account/ban/unban', "admin:accountbanunban");
$route->get('/account/details/{account}', "admin:accountdetails");
$route->get('/account/balance', "admin:accountbalance");

/** Character */
$route->get('/character/add/staff', "admin:characteraddstaff");
$route->get('/character/ban/unban', "admin:characterbanunban");
$route->get('/character/all/characters', "admin:charactersall");
$route->get('/character/edit/{char}', "admin:characteredit");

/** Template */
$route->get('/templates', 'admin:templates');

/** Administration Post */
$route->group('administration')->namespace('Amwdeveloper\controller');
$route->post("/auth/new/download", "authadmin:postnewdownload");
$route->post("/auth/to/edit/download/{id}", "authadmin:posttoeditdownload");
$route->get('/auth/to/remove/download/{id}', "authadmin:posttoremovedownload");

/** Login account */
$route->post('/auth/login/account', "authadmin:postloginaccount");

/** Account */
$route->post('/auth/account/add/coin', "authadmin:postaccountaddcoin");
$route->post('/auth/account/remove/coin', "authadmin:postaccountremovecoin");
$route->post('/auth/account/add/vip', "authadmin:postaccountaddvip");
$route->post('/auth/account/remove/vip', "authadmin:postaccountremovevip");
$route->post('/auth/account/ban/unban', "authadmin:postaccountbanunban");
$route->post('/auth/account/search', "authadmin:postsearchaccount");

/** Character */
$route->post('/auth/character/add/staff', "authadmin:postcharacteraddstaff");
$route->post('/auth/character/ban/unban', "authadmin:postcharacterbanunban");
$route->post('/auth/character/edit', "authadmin:postcharacteredit");

/** Template Post */
$route->get('/templates/{name}/active', 'authadmin:templatespost');