var events = [
    ["BLOOD CASTLE", ["01:30", "03:30", "05:30", "07:30", "09:30", "11:30", "13:30", "15:30", "17:30", "19:30", "21:30", "23:30"]],
    ["DEVIL SQUARE", ["02:00", "07:00", "12:00", "17:00", "22:00"]],
    ["CHAOS CASTLE", ["15:20", "20:20", "23:20"]],
    ["GOLDEN INVASION", ["10:00", "15:00", "17:00", "22:00"]],
    ["DRAGON INVASION", ["11:00", "13:00", "16:00", "19:00"]],
    ["BATTLE ROYALE", ["22:00"]],
    ["INVASÃO BOSS", ["10:00", "19:00", "23:00"]],
    ["INVASÃO GIANT DRAKAN", ["15:00", "20:00"]],
    ["MATA-MATA", ["12:00", "18:30", "23:30"]],
    ["SURVIVOR", ["13:00", "16:00", "19:30"]],
    ["HAPPY HOUR", ["14:00", "20:20"]],
    ["CAÇA AO TESOURO", ["13:30", "22:30"]],
];

var eventsdays = [
    ["REI DO MU", [1],
        ["16:00"]
    ],
];

var eventsTime = [

];



function toSeconds(h, m, s) {
    return h * 3600 + m * 60 + s;
}

function DateUTC(offset) {
    var d = new Date();
    var utc = d.getTime() + (d.getTimezoneOffset() * 60000);
    return new Date(utc + (3600000 * offset));
}

function updateEventsTime(eventsTime, divId) {
    var d = DateUTC('-3');
    var time = toSeconds(d.getHours(), d.getMinutes(), d.getSeconds());

    var html = '';
    for (var i in eventsTime) {
        var line = eventsTime[i];

        if (line.length == 2 && typeof (line[1]) == 'object') {
            var j;
            for (j = 0; j < line[1].length; j++) {
                var t = line[1][j].split(':');
                t = toSeconds(t[0], t[1], 0);

                if (t > time) {
                    break;
                }
            }

            j = j % eventsTime[i][1].length;
            var t = eventsTime[i][1][j].split(':');

            var diff = toSeconds(t[0], t[1], 0) - time;
            if (diff < 0) {
                diff += 3600 * 24;
            }

            var h = parseInt(diff / 3600);
            diff -= 3600 * h;
            var m = parseInt(diff / 60);
            var s = diff - m * 60;

            var countdown = h + ':' + ("0" + m).slice(-2) + ':' + ("0" + s).slice(-2);

            html += '<li>' + line[0] + ': <span>' + countdown + '</span></li>';

        } else if (line.length == 3) {

            var week = [0, 0, 0, 0, 0, 0, 0];
            var weekH = [0, 0, 0, 0, 0, 0, 0];
            for (j in line[1]) {
                var t = line[2][j].split(':');
                t = toSeconds(t[0], t[1], 0);
                week[line[1][j] - 1] = t;
                weekH[line[1][j] - 1] = line[2][j];
            }

            var dd = d.getDay();
            var total = 0;
            while (1) {
                if (week[dd] && ((dd == d.getDay() && week[dd] > time) || dd != d.getDay())) {

                    var w = ['', '', '', '', '', '', ''][dd];

                    if (dd == d.getDay()) {
                        w = '';
                    }

                    var diff = (dd * 24 * 60 * 60 + week[dd]) - (d.getDay() * 24 * 60 * 60 + time);

                    if (diff < 0) {
                        diff += 7 * 24 * 60 * 60;
                    }

                    var days = parseInt(diff / (24 * 60 * 60));
                    diff -= days * (24 * 60 * 60);
                    var h = parseInt(diff / 3600);
                    diff -= 3600 * h;
                    var m = parseInt(diff / 60);
                    var s = diff - m * 60;

                    if (days) {
                        count = days + 'd ' + h + 'h';
                    } else {
                        var count = h + ':' + ("0" + m).slice(-2) + ':' + ("0" + s).slice(-2);
                    }
                    html += '<li>' + '' + line[0] + ': <span>' + count + '</span></li>';
                    break;
                }

                if (total++ > 8) {
                    html += '<li>' + line[0] + ': <span>7d</span></li>';
                    break;
                }
                dd = (dd + 1) % 7;
            }
        } else {
            html += '<li>' + line[0] + ': <span>' + line[1] + '</span></li>';
        }
    }
    $('.' + divId).html(html);
}
setInterval(function () {
    updateEventsTime(events, 'events-day');
    updateEventsTime(eventsdays, 'events-week');
}, 1000);