<?php

namespace Amwdeveloper\model;

use Amwdeveloper\controller\connection;
use PDO;
use PDOException;

class layer extends connection
{
    protected ?object $data = null;
    protected ?PDOException $fail = null;

    protected ?string $table = null;
    protected ?array $params = null;

    protected string $columns = "*";
    protected ?string $where = null;
    protected ?string $orderby = null;
    protected ?string $limit = null;
    protected ?string $inner = null;

    public function __get($name)
    {
        return $this->data->$name ?? null;
    }

    public function __set($name, $value)
    {
        $this->data ??= new \stdClass();
        $this->data->$name = $value;
    }

    public function data(): ?object
    {
        return $this->data;
    }

    public function fail(): ?PDOException
    {
        return $this->fail;
    }

    public function table(string $table): self
    {
        $this->table = $table;
        return $this;
    }

    public function columns(string $column = "*"): self
    {
        $this->columns = $column;
        return $this;
    }

    public function where(string $where, string $params): self
    {
        $this->where = " WHERE {$where}";
        parse_str($params, $this->params);
        return $this;
    }

    public function orderby(string $order, string $type = "DESC"): self
    {
        $this->orderby = " ORDER BY {$order} {$type}";
        return $this;
    }

    public function limit(int $limit = 10): self
    {
        $this->limit = " TOP {$limit}";
        return $this;
    }

    public function inner(string $inner): self
    {
        $this->inner = " {$inner}";
        return $this;
    }

    private function reset(): void
    {
        $this->table = null;
        $this->params = null;
        $this->columns = "*";
        $this->where = null;
        $this->orderby = null;
        $this->limit = null;
        $this->inner = null;
    }

    public function all(): ?array
    {
        try {
            $sql = "SELECT {$this->limit} {$this->columns} FROM {$this->table}{$this->inner}{$this->where}{$this->orderby}";
            $stmt = $this->db()->prepare($sql);
            $stmt->execute($this->params ?? []);
            $result = $stmt->fetchAll(PDO::FETCH_CLASS, static::class);
            $this->reset();
            return $result;

        } catch (PDOException $e) {
            $this->fail = $e;
            return null;
        }
    }

    public function get(): ?object
    {
        try {
            $sql = "SELECT {$this->limit} {$this->columns} FROM {$this->table}{$this->inner}{$this->where}{$this->orderby}";
            $stmt = $this->db()->prepare($sql);
            $stmt->execute($this->params ?? []);
            $result = $stmt->fetchObject(static::class);
            $this->reset();
            return $result;

        } catch (PDOException $e) {
            $this->fail = $e;
            return null;
        }
    }

    public function count(): ?object
    {
        try {
            $sql = "SELECT COUNT({$this->columns}) as amount FROM {$this->table}{$this->where}";
            $stmt = $this->db()->prepare($sql);
            $stmt->execute($this->params ?? []);
            $result = $stmt->fetchObject();
            $this->reset();
            return $result;

        } catch (PDOException $e) {
            $this->fail = $e;
            return null;
        }
    }

    public function created(array $data): ?int
    {
        try {
            $keys = implode(", ", array_keys($data));
            $values = ":" . implode(", :", array_keys($data));
            $stmt = $this->db()->prepare("INSERT INTO {$this->table} ({$keys}) VALUES ({$values})");
            $stmt->execute($data);
            $id = (int)$this->db()->lastInsertId();
            $this->reset();
            return $id;

        } catch (PDOException $e) {
            $this->fail = $e;
            return null;
        }
    }

    public function updated(array $data): ?int
    {
        try {
            $set = [];
            foreach ($data as $key => $value) {
                $set[] = "{$key} = :{$key}";
            }

            $sql = "UPDATE {$this->table} SET " . implode(", ", $set) . $this->where;
            $stmt = $this->db()->prepare($sql);
            $stmt->execute(array_merge($data, $this->params ?? []));
            $rows = $stmt->rowCount();
            $this->reset();
            return $rows;

        } catch (PDOException $e) {
            $this->fail = $e;
            return null;
        }
    }

    public function destroy(): ?int
    {
        try {
            $stmt = $this->db()->prepare("DELETE FROM {$this->table}{$this->where}");
            $stmt->execute($this->params ?? []);
            $rows = $stmt->rowCount();
            $this->reset();
            return $rows;

        } catch (PDOException $e) {
            $this->fail = $e;
            return null;
        }
    }
}
